/*
 * Toolkit GUI, an application built for operating pinkRF's signal generators.
 *
 * Contact: https://www.pinkrf.com/contact/
 * Copyright © 2018-2024 pinkRF B.V
 * GNU General Public License version 3.
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License along with this program. If not, see https://www.gnu.org/licenses/
 *
 * Author: Iordan Svechtarov
 */

#ifndef NUMPAD_H
#define NUMPAD_H
#include <math.h>
#include <QPushButton>
#include <QLabel>
#include <QTimer>

class Numpad : public QObject
{
	Q_OBJECT

private:
	enum NumpadSign
	{
		Positive,
		Negative
	};

	const int	decimal_length = 5;
	const int	fractal_length = 4;
	double	min_input = pow(10,-(fractal_length));
	double	max_input = pow(10,decimal_length);
	int		index_cursor = 0;
	int		index_cursor_relative_period = 0;
	int		magnitude_cursor = 0;
	bool	cursor_status = false;
	bool	overwrite_permission = true;	//Used to control whether an input with the numpad would append to or overwrite the current number
	double	multiplier = 1;
	double	*number_ptr;
	QString		numberstring = "0";
	char		number_sign = '+';
	QLabel		*displaylabel;
	QLabel		*unitlabel;
	QPushButton *period_button;
	QPushButton *sign_button;
	QPushButton *target_button;
	QTimer		*blink_timer;

	void update_display();
	void pad_with_zeroes();
	void update_cursor_index();
	void add_number(int num);
	void increment_number(int incrementation);
	bool get_input_permission();
	bool get_increment_permission(double val);

	void set_number_sign(Numpad::NumpadSign sign);
	void set_index_cursor_relative_period(int val);
	int	get_index_cursor_relative_period();
	int get_index_cursor();
	int get_index_period(QString numstring);
	int get_cursor_magnitude();

	int calculate_precision(QString numstring);
	void force_cursor_highlight(bool state);

public:
	Numpad(int dec_length, int fract_length, QLabel *display, QLabel *unit_display, QPushButton *period_btn, QPushButton *sign_btn);
	void load_value(double *parameter, QString unit, bool enable_period = true, bool enable_sign = false, double scale_multiplier = 1);
	void setDisplay(QLabel* display);
	void setUnitDisplay(QLabel *unit_display);
	void setOutputButton(QPushButton* button);
	void setSignButton(QPushButton *button);

	void press_confirm_input();
	void press_1();
	void press_2();
	void press_3();
	void press_4();
	void press_5();
	void press_6();
	void press_7();
	void press_8();
	void press_9();
	void press_0();
	void press_period();
	void press_delete();
	void press_delete_all();
	void press_indicator_left();
	void press_indicator_right();
	void press_plus();
	void press_minus();
	void press_sign();

private slots:
	void cursor_blink_update();

signals:
	void value_confirmed_signal(QPushButton*, double*);

};

#endif // NUMPAD_H
